/*
 * Decompiled with CFR 0.152.
 */
package view;

import data.Constants;
import data.Theme;
import java.awt.Dimension;
import java.awt.Toolkit;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import view.Fonts;
import view.StaticDrawer;

public class View {
    private int fps;
    private int code;
    public static boolean fullScr;
    private DisplayMode sM;
    boolean bPlayerModelInitialized = false;

    public View(int iFramesPerSecond) {
        this.createDisplay();
        this.setupOpenGl();
        GL11.glPushAttrib(1048575);
        Fonts.initialize();
        this.fps = iFramesPerSecond;
        fullScr = true;
        if (!Constants.allowFullScr) {
            fullScr = false;
        }
        this.sM = null;
    }

    private void createDisplay() {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension scrnsize = toolkit.getScreenSize();
            float myResolution = (float)scrnsize.width / (float)scrnsize.height;
            float availableRes = 0.0f;
            int compatibleResI = 0;
            float smallWidth = scrnsize.width;
            System.out.println(Display.getDisplayMode().isFullscreenCapable());
            DisplayMode[] d = Display.getAvailableDisplayModes();
            int i = 0;
            while (i < d.length) {
                System.out.println(d[i]);
                availableRes = (float)d[i].getWidth() / (float)d[i].getHeight();
                if (myResolution == availableRes && (float)d[i].getWidth() >= smallWidth) {
                    compatibleResI = i;
                    smallWidth = d[i].getWidth();
                }
                ++i;
            }
            this.sM = d[compatibleResI];
            Display.setDisplayMode(this.sM);
            Constants.VIEW_HEIGHT = this.sM.getHeight();
            Constants.VIEW_WIDTH = this.sM.getWidth();
            Display.setFullscreen(fullScr);
            Fonts.resolutionScale = (float)Constants.VIEW_HEIGHT / 600.0f;
            Constants.DEFAULT_PLAYER_X = Constants.VIEW_WIDTH / 2;
            Constants.DEFAULT_PLAYER_Y = Constants.VIEW_HEIGHT / 2;
            Display.setTitle(Constants.GAME_NAME);
            Display.create();
            Display.setVSyncEnabled(true);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    private void setupOpenGl() {
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, Constants.VIEW_WIDTH, Constants.VIEW_HEIGHT, 0.0, 1.0, -1.0);
        GL11.glMatrixMode(5888);
    }

    public void update() {
        Display.update();
        Display.sync(this.fps);
        this.detectKonami();
        if (Constants.allowFullScr && (fullScr && !Display.isFullscreen() || !fullScr && Display.isFullscreen())) {
            System.out.println("Performing Display.destroy()/create() cycle");
            this.sM = Display.getDisplayMode();
            Display.destroy();
            try {
                Display.setDisplayMode(this.sM);
                Display.setTitle("Music Dots");
                Display.setFullscreen(fullScr);
                Display.create();
                Display.setVSyncEnabled(true);
                Constants.VIEW_HEIGHT = this.sM.getHeight();
                Constants.VIEW_WIDTH = this.sM.getWidth();
                this.setupOpenGl();
                Fonts.initialize();
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
        }
        Theme.setClearColor();
        if (!this.bPlayerModelInitialized) {
            StaticDrawer.initializeTextures();
            this.bPlayerModelInitialized = true;
        }
        GL11.glClear(16640);
    }

    public void destroy() {
        Display.destroy();
    }

    public boolean closeRequested() {
        return Display.isCloseRequested();
    }

    public void detectKonami() {
        if ((this.code == 0 || this.code == 1) && Keyboard.isKeyDown(200)) {
            ++this.code;
        } else if ((this.code == 2 || this.code == 3) && Keyboard.isKeyDown(208)) {
            ++this.code;
        } else if ((this.code == 4 || this.code == 6) && Keyboard.isKeyDown(203)) {
            ++this.code;
        } else if ((this.code == 5 || this.code == 7) && Keyboard.isKeyDown(205)) {
            ++this.code;
        } else if (this.code == 8 && Keyboard.isKeyDown(48)) {
            ++this.code;
        } else if (this.code == 9 && Keyboard.isKeyDown(30)) {
            ++this.code;
        } else if (this.code == 10 && Keyboard.isKeyDown(28)) {
            Constants.KONAMI = !Constants.KONAMI;
            this.code = 0;
        }
    }
}

